/*

Copyright (c) 2009-2010 Thomas Dennis.

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "csv.h"

/* Export a table to a CSV file. */

int csvSaveCSV( const CsvTable *csv, const char fname[], char cend, char qchr )
{

  FILE *save_file = NULL;
  long i, j, len, k;

  if( !csv || !fname ) { return -1; }
  if( !csv->cell     ) { return -1; }

  /* Open output file. */

  save_file = fopen( fname, "wb" );

  if( !save_file ) { return 1; }

  /* Write file data. */

  for( j = 0; j < csv->height; j++ )
  {

    for( i = 0; i < csv->width; i++ )
    {

      if( csv->cell[i][j] )
      {

        len = strlen( csv->cell[i][j] );

        if( len > 0 )
        {

          fputc( qchr, save_file );

          for( k = 0; k < len; k++ )
          {

            if( csv->cell[i][j][k] == qchr ) { fputc( qchr, save_file ); }

            fputc( csv->cell[i][j][k], save_file );

          }

          fputc( qchr, save_file );

        }

      }

      if( i < csv->width - 1 ) { fputc( cend, save_file ); }

    }

      fputc( '\n', save_file );

  }

  /* Close the file. */

  fclose( save_file );

  /* Exit function (success). */

  return 0;

}

/* Export a table to an HTML file. */

int csvSaveHTML( const CsvTable *csv, const char file_name[] )
{

  FILE *save_file = NULL;
  long i, j, len, k;

  if( !csv || !file_name ) { return -1; }
  if( !csv->cell         ) { return -1; }

  /* Open output file. */

  save_file = fopen( file_name, "wb" );

  if( !save_file ) { return 1; }

  /* Write file header and table start. */

  fprintf( save_file, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" " );
  fprintf( save_file, "\"http://www.w3.org/TR/html4/strict.dtd\">" );
  fprintf( save_file, "<html>\n <head>\n  <meta http-equiv=\"content-type\" " );
  fprintf( save_file, "content=\"text/html;charset=utf-8\">\n" );
  fprintf( save_file, "  <title>Exported Spreadsheet</title>\n" );
  fprintf( save_file, " </head>\n <body>\n" );
  fprintf( save_file, "  <h1>Exported Spreadsheet</h1>\n" );
  fprintf( save_file, "  <table border=\"2\">\n" );

  /* Write table contents. */

  for( j = 0; j < csv->height; j++ )
  {

    fprintf( save_file, "   <tr>\n" );

    for( i = 0; i < csv->width; i++ )
    {

      fprintf( save_file, "    <td>" );

      if( csv->cell[i][j] )
      {

        len = strlen( csv->cell[i][j] );

        if( len > 0 )
        {

          for( k = 0; k < len; k++ )
          {

            if(      csv->cell[i][j][k]=='<' ) { fprintf( save_file, "&lt;" ); }
            else if( csv->cell[i][j][k]=='>' ) { fprintf( save_file, "&gt;" ); }
            else { fputc( csv->cell[i][j][k], save_file ); }

          }

        } else { fprintf( save_file, "&nbsp;" ); }

      } else { fprintf( save_file, "&nbsp;" ); }

      fprintf( save_file, "</td>\n" );

    }

    fprintf( save_file, "   </tr>\n" );

  }

  /* Write table end and end of body element. */

  fprintf( save_file, "  </table>\n  <p>\n   " );
  fprintf( save_file, "<a href=\"http://validator.w3.org/check?uri=referer\"" );
  fprintf( save_file, "><img\nsrc=\"http://www.w3.org/Icons/valid-html401\" " );
  fprintf( save_file, "\nalt=\"Valid HTML 4.01 Strict\" height=\"31\" " );
  fprintf( save_file, "width=\"88\"></a>\n  </p>\n </body>\n</html>" );

  /* Close the file. */

  fclose( save_file );

  /* Exit function (success). */

  return 0;

}
